//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property description "Mini Chat for demonstration of using sockets in MQL5."
#property link      "https://www.mql5.com/"
#property version   "1.00"
//+------------------------------------------------------------------+
#define def_IndicatorMiniChat	"Indicators\\Mini Chat\\Mini Chat.ex5"
#resource "\\" + def_IndicatorMiniChat
//+------------------------------------------------------------------+
#include <Market Replay\Mini Chat\C_Connection.mqh>
#include <Market Replay\Defines.mqh>
//+------------------------------------------------------------------+
input string 	user00 = "127.0.0.1"; 		//Address
input ushort	user01 = 27015;				//Port
//+------------------------------------------------------------------+
long 	gl_id;
int 	gl_sub;
C_Connection *Conn;
//+------------------------------------------------------------------+
int OnInit()
{
	Conn = new C_Connection(user00, user01);
	if (_LastError > ERR_USER_ERROR_FIRST)
		return INIT_FAILED;	
	ChartIndicatorAdd(gl_id = ChartID(), gl_sub = (int) ChartGetInteger(gl_id, CHART_WINDOWS_TOTAL), iCustom(NULL, 0, "::" + def_IndicatorMiniChat));

	EventSetTimer(1);

	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	EventKillTimer();
	delete Conn;
	ChartIndicatorDelete(gl_id, gl_sub, ChartIndicatorName(gl_id, gl_sub, 0));
}
//+------------------------------------------------------------------+
void OnTick()
{
}
//+------------------------------------------------------------------+
void OnTimer()
{
	string sz0 = (*Conn).ConnectionRead();
	if (sz0 != "")
		EventChartCustom(gl_id, evChatReadSocket, 0, 0, sz0);
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
	if (id == CHARTEVENT_CUSTOM + evChatWriteSocket)
		(*Conn).ConnectionWrite(sparam);
}
//+------------------------------------------------------------------+